// PARA TESTAR
let json = {
  praca: "Campinas - SP",
  ativo: "elevadores",
  inicio: "22/4/2025",
  fim: "15/5/2025",
  generica_linha_1: "Altas ofertas para voce",
  generica_linha_2: "celebrar com uma viagem.",
  tipo_linha_1: "",
  oferta_linha_1: "Pacote para",
  oferta_linha_2: "HOTEL FULANO DE TAL Beberibe- CE",
  qtde_dias: "5 dias",
  icone_1: "passagem_aerea",
  icone_2: "hospedagem",
  icone_3: "cafe_manha",
  icone_4: "",
  icone_5: "",
  icone_6: "",
  txt_a_partir_de: "A partir de ",
  qtde_parcelas: "12x",
  video_destino: "sauipe_ala_terra",
  texto_legal: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis et elementum massa, non auctor lacus. Donec magna dolor, consectetur vulputate placerat sit amet, malesuada in ex. Donec malesuada nulla eu turpis hendrerit rhoncus. Etiam aliquam pulvinar massa sed hendrerit. In hac habitasse platea dictumst. Aliquam turpis purus, semper sed nisi sit amet, eleifend imperdiet felis. Nullam semper risus ipsum, in feugiat urna porttitor quis. Suspendisse sollicitudin augue vitae ante aliquam sagittis. Aliquam feugiat interdum lectus in porta. Maecenas metus ante, placerat id purus venenatis, elementum imperdiet leo. Phasellus a tortor et massa gravida rhoncus sed eget lectus. Nulla mattis tincidunt diam, molestie volutpat lorem venenatis non. Quisque nulla sapien, ullamcorper quis justo accumsan, tristique posuere odio. Aliquam finibus tincidunt libero ut malesuada.",
  tipo_pessoa: "",
  selo_1: "all_inclusive",
  selo_2: "",
  valor_parcela: "88",
  txt_total_pessoa: "Total: R$ 816 por pessoa",
  tipo_oferta: "valor",
  desconto_percentual: "88",
  icone_grande: "_faixa",
  passageiro_gratis: "2",
  img_abertura: "pacote",
  publico: "C",
  tipo_giovana: "gio_casual",
  oferta_pix: "sim",
  cor_fundo : "azul",
  foto_primeiro_step: "familia_1",
};
// prepareTemplate({
//   data: { item: { current_dynamic_data: { text: JSON.stringify(json) } } },
// });

function prepareTemplate(ev) {
  console.log(":: prepareTemplate CVC ::");

  // esconde animação
  const bannerElement = document.getElementById("banner");
  // bannerElement.style.display = "none";
  bannerElement.style.opacity = "0";

  const allElements = document.querySelectorAll("#banner *");
  playPause(allElements, "paused");

  const textoTemplate = ev.data.item.current_dynamic_data.text || "";
  parseTemplateData(textoTemplate);
}

function showTemplate(ev) {
  const bannerElement = document.getElementById("banner");
  bannerElement.style.opacity = "1";

  const allElements = document.querySelectorAll("#banner *");
  playPause(allElements, "initial");
}

function parseTemplateData(textoTemplate) {
  let jsonData = null;
  try {
    const texto = JSON.parse(textoTemplate);
    jsonData = texto;
  } catch (error) {
    console.log("Template Error :: erro ao fazer parse do JSON! :: ", error);
    return false;
  }

  conteudoValido = true;

  if (jsonData != null) {
    fillScenes(jsonData);
  } else {
    fallback();
  }
}

function fallback() {
  console.log(":: fallback ::");
  //const bannerElement = document.getElementById("banner");
  //bannerElement.style.display = "block";
}

async function setGiovana(json) {
  try {
    const giovana = document.querySelectorAll('.giovana > div');
    giovana.forEach(element => element.style.display = 'none');
    document.querySelector(`.${json.tipo_giovana}`).style.display = 'block';
  } catch (error) {
    throw error;
  }
}

async function setImagemAbertura(json) {
  try {
    const foto = document.querySelector(".foto_primeiro_step");
    const src = await loadImage(`./foto_primeiro_step/${json.foto_primeiro_step}.jpg`);
    foto.style.background = `url(${src}) no-repeat`;
    foto.style.backgroundSize = `cover`;
  } catch (error) {
    throw error;
  }
}

async function setDestino(json) {
  try {
    const destino = document.querySelector(".destino");
    const src = await loadImage(`./destinos/${json.video_destino}.jpg`);
    destino.style.background = `url(${src}) no-repeat`;
    destino.style.backgroundSize = `cover`;
  } catch (error) {
    throw error;
  }
}

async function setTitle(json) {
  try {
    const setLinha = async (linha_nome) => {
      const linha = document.querySelector(`.${linha_nome} span`);
      linha.innerHTML = json[`generica_${linha_nome}`];
      return await adjustFontSize(linha.parentElement);
    };

    const listFontSize = await Promise.all(
      ["linha_1", "linha_2"].map(setLinha)
    );
    const minFontSize = Math.min(...listFontSize);

    ["linha_1", "linha_2"].forEach((linha_nome) => {
      document.querySelector(
        `.${linha_nome} span`
      ).style.fontSize = `${minFontSize}px`;
    });
  } catch (error) {
    throw error;
  }
}

async function setSeloPix(json) {
  try {
    const seloPix = document.querySelector(".selo_pix");
    const ofertaValor = document.querySelector(".valor");

    if (json.oferta_pix !== 'sim') {
      seloPix.style.display = 'none';
      ofertaValor.style.borderRadius = '20px';
    }
  } catch (error) {
    throw error;
  }
}

async function setSelos(json) {
  try {
    const selos = {
      aereo_incluso: {texto: "Aéreo Incluso"},
      all_inclusive: {texto: "All Inclusive "},
      confira_ingresso_disney: {texto: "Confira ingressos para <i>Walt Disney World</i> Resort"},
      costa_diadema: {texto: "Costa Diadema"},
      costa_favolosa: {texto: "Costa Favolosa"},
      costa_pacifica: {texto: "Costa Pacífica "},
      crianca_gratis: {texto: "Criança grátis até 17 anos"},
      crianca_gratis_hospedagem: {texto: "Hospedagem grátis para criança até 17 anos"},
      ingresso_acquamotion: {texto: "Incluso Ingresso Acquamotion"},
      ingresso_beach: {texto: "Incluso Ingresso Beach Park"},
      ingresso_beto_carrero: {texto: "Incluso Ingresso Beto Carrero World"},
      ingresso_disney_paris: {texto: "Incluso Ingresso Disneyland® Paris"},
      ingresso_farellones: {texto: "Incluso Ingresso Farellones"},
      ingresso_incluso: {texto: "Incluso Ingresso"},
      ingresso_natal_luz: {texto: "Incluso Ingresso Natal Luz "},
      ingresso_snowland: {texto: "Incluso Ingresso Snowland"},
      ingresso_universal: {texto: "Incluso Ingresso Universal Studios"},
      ingresso_walt_disney: {texto: "Incluso Ingresso Walt Disney World Resort"},
      kit_boas_vindas: {texto: "Kit boas-vindas"},
      msc_armonia: {texto: "MSC Armonia"},
      msc_grandiosa: {texto: "MSC Grandiosa"},
      msc_orchestra: {texto: "MSC Orchestra"},
      msc_seaview: {texto: "MSC Seaview"},
      temporada_inverno: {texto: "Temporada de Inverno"},
      vila_gale_cumbuco: {texto: "Vila Galé Cumbuco"},
      ingresso_blue_park: {texto: "Incluso Ingresso Blue Park Aquático"},
      celebre_natal: {texto: "Celebre o Natal"},
      fast_pass_adrenaline: {texto: "Fast Pass Adrenaline"},
      final_de_ano: {texto: "Final de Ano"},
      ingresso_vila_monica: {texto: "Ingresso Vila da Mônica"},
      msc_divina: {texto: "MSC Divina"},
      msc_lirica: {texto: "MSC Lirica"},
      msc_preziosa: {texto: "MSC Preziosa"},
      msc_virtuosa: {texto: "MSC Virtuosa"},
      regiao_alentejo: {texto: "Região Alentejo"},
      msc_musica: {texto: "MSC Musica"}
    };

    const selo = document.querySelector(`.selo1`);
    const selo1 = selos[json.selo_1]?.texto;

    if (selo1) {
      selo.innerHTML += `<span><span>${selo1}</span></span>`;

      await new Promise((resolve) => setTimeout(resolve, 300));

      await adjustFontSize(selo);
    } else {
      selo.style.display = "none";
    }
  } catch (error) {
    throw error;
  }
}

async function setOfertas(json) {
  const oferta = document.querySelector(`.${json.tipo_oferta}`);
  oferta.style.display = "block";

  if (json.tipo_oferta === "circuito") {
    // const oferta_linha_1 = oferta.querySelector(".linha_1 span");
    // const oferta_linha_2 = oferta.querySelector(".linha_2 span");
    // const passageiro_gratis = oferta.querySelector(".passageiro_gratis");
    // oferta_linha_1.innerHTML = `${json.oferta_linha_1}<br>${json.oferta_linha_2}`;
    // oferta_linha_2.innerHTML = json.oferta_linha_2;
    // passageiro_gratis.innerHTML = `com o ${json.passageiro_gratis}º passageiro`;
    // await Promise.all([
      // adjustFontSize(oferta_linha_1.parentElement),
      // adjustFontSize(oferta_linha_2.parentElement),
    // ]);
  } else if (json.tipo_oferta === "desconto") {
    // const oferta_linha_1 = oferta.querySelector(".linha_1 span");
    // const oferta_linha_2 = oferta.querySelector(".linha_2 span");
    // const desconto_percentual = oferta.querySelector(".desconto_percentual");

    // oferta_linha_1.innerHTML = json.oferta_linha_1;
    // oferta_linha_2.innerHTML = json.oferta_linha_2;
    // desconto_percentual.innerHTML = `${json.desconto_percentual}%`;

    // await new Promise((resolve) => setTimeout(resolve, 200));

    // await Promise.all([
    //   adjustFontSize(oferta_linha_1.parentElement),
    //   adjustFontSize(oferta_linha_2.parentElement),
    // ]);
  } else if (json.tipo_oferta === "valor") {
    const oferta_linha_1 = oferta.querySelector(".linha_1 span");
    const oferta_linha_2 = oferta.querySelector(".linha_2 span");
    const qtde_dias = oferta.querySelector(".qtde_dias span");
    const icones = oferta.querySelector(".icones");
    const qtde_parcelas = oferta.querySelector(".qtde_parcelas > span");
    const valor_parcela = oferta.querySelector(".valor_parcela span");
    const total_pessoa = oferta.querySelector(".total_pessoa span");

    const loadIcons = [];
    for (let i = 1; i < 7; i++) {
      const icone = json[`icone_${i}`];

      if (!icone) continue;

      loadIcons.push(
        loadImage(`./icones_oferta/${icone}.png`).then((src) => {
          const img = document.createElement("img");
          img.src = src;
          icones.appendChild(img);
        })
      );
    }

    oferta_linha_1.innerHTML = json.oferta_linha_1;
    oferta_linha_2.innerHTML = json.oferta_linha_2;
    qtde_dias.innerHTML = json.qtde_dias;
    qtde_parcelas.innerHTML = json.qtde_parcelas.replace("x", "<span>x</span>");
    valor_parcela.innerHTML = json.valor_parcela;
    total_pessoa.innerHTML = json.txt_total_pessoa;

    // esperar mais por causa do qtde_parcelas
    await new Promise((resolve) => setTimeout(resolve, 300));

    await Promise.all([
      ...loadIcons,
      adjustFontSize(oferta_linha_1.parentElement),
      adjustFontSize(oferta_linha_2.parentElement),
      adjustFontSize(qtde_dias.parentElement),
      adjustFontSize(qtde_parcelas.parentElement),
      adjustFontSize(valor_parcela.parentElement),
      adjustFontSize(total_pessoa.parentElement),
    ]);

    valor_parcela.parentElement.style.overflow = "visible";
    if (json.valor_parcela.length > 3) valor_parcela.parentElement.style.top = "107px";
  }
}

async function setTextoLegal(json) {
  try {
    const texto_legal = document.querySelector(".texto_legal span");
    texto_legal.innerHTML = json.texto_legal;
    await adjustFontSize(texto_legal.parentElement);
  } catch (error) {
    throw error;
  }
}

async function setCores(json) {
  try {
    const seloPix = document.querySelector(".selo_pix");
    const texto_legal = document.querySelector(".texto_legal");

    const srcSeloPix = await loadImage(`./assets/selo_${json.cor_fundo === 'amarelo' ? 'azul' : 'amarelo'}.png`);

    seloPix.style.background = `url(${srcSeloPix}) no-repeat`;
    texto_legal.style.color = json.cor_fundo === 'amarelo' ? '#0d00b4' : '#fbdb32';

    const map = [
      { el: '.borda', img: { amarelo: 'fundo_amarelo', azul: 'fundo_azul' } },
      { el: '.fundo_descontao .stroke', img: { amarelo: 'descontao_stroke_azul', azul: 'descontao_stroke_amarelo' } },
      { el: '.fundo_descontao .fill', img: { amarelo: 'descontao_fill_azul', azul: 'descontao_fill_amarelo' } },
      { el: '.do_cliente .e', img: { amarelo: 'do_cliente_e_azul', azul: 'do_cliente_e_amarelo' } },
      { el: '.do_cliente .t', img: { amarelo: 'do_cliente_t_azul', azul: 'do_cliente_t_amarelo' } },
      { el: '.do_cliente .n', img: { amarelo: 'do_cliente_n_azul', azul: 'do_cliente_n_amarelo' } },
      { el: '.do_cliente .i', img: { amarelo: 'do_cliente_i_azul', azul: 'do_cliente_i_amarelo' } },
      { el: '.do_cliente .l', img: { amarelo: 'do_cliente_l_azul', azul: 'do_cliente_l_amarelo' } },
      { el: '.do_cliente .c', img: { amarelo: 'do_cliente_c_azul', azul: 'do_cliente_c_amarelo' } },
      { el: '.do_cliente .o', img: { amarelo: 'do_cliente_o_azul', azul: 'do_cliente_o_amarelo' } },
      { el: '.do_cliente .d', img: { amarelo: 'do_cliente_d_azul', azul: 'do_cliente_d_amarelo' } },
      { el: '.descontao .o', img: { amarelo: 'descontao_o_azul', azul: 'descontao_o_amarelo' } },
      { el: '.descontao .t', img: { amarelo: 'descontao_t_azul', azul: 'descontao_t_amarelo' } },
      { el: '.descontao .n', img: { amarelo: 'descontao_n_azul', azul: 'descontao_n_amarelo' } },
      { el: '.descontao .c', img: { amarelo: 'descontao_c_azul', azul: 'descontao_c_amarelo' } },
      { el: '.descontao .e', img: { amarelo: 'descontao_e_azul', azul: 'descontao_e_amarelo' } },
      { el: '.descontao .d', img: { amarelo: 'descontao_d_azul', azul: 'descontao_d_amarelo' } },
      { el: '.descontao .s', img: { amarelo: 'descontao_s_azul', azul: 'descontao_s_amarelo' } },
      { el: '.descontao .a', img: { amarelo: 'descontao_a_azul', azul: 'descontao_a_amarelo' } },
      { el: '.te', img: { amarelo: 'te_azul', azul: 'te_amarelo' } },
      { el: '.en', img: { amarelo: 'en_azul', azul: 'en_amarelo' } },
      { el: '.cli', img: { amarelo: 'cli_azul', azul: 'cli_amarelo' } },
      { el: '.do', img: { amarelo: 'do_azul', azul: 'do_amarelo' } },
      { el: '.ao', img: { amarelo: 'ao_azul', azul: 'ao_amarelo' } },
      { el: '.nt', img: { amarelo: 'nt_azul', azul: 'nt_amarelo' } },
      { el: '.sco', img: { amarelo: 'sco_azul', azul: 'sco_amarelo' } },
      { el: '.de', img: { amarelo: 'de_azul', azul: 'de_amarelo' } },
      { el: '.logo_cvc .bg', img: { amarelo: 'logo_bg_azul', azul: 'logo_bg_amarelo' } },
      { el: '.logo_cvc .c', img: { amarelo: 'logo_c_amarelo', azul: 'logo_c_azul' } },
      { el: '.logo_cvc .v', img: { amarelo: 'logo_v_amarelo', azul: 'logo_v_azul' } },
      { el: '.logo_cvc .curva1', img: { amarelo: 'logo_curva1_amarelo', azul: 'logo_curva1_azul' } },
      { el: '.logo_cvc .curva2', img: { amarelo: 'logo_curva2_amarelo', azul: 'logo_curva2_azul' } },
    ]

    const allImgs = await Promise.all(map.map((item) => loadImage(`./assets/${item.img[json.cor_fundo]}.svg`)))
    allImgs.forEach((img, i) => {
      document.querySelectorAll(map[i].el).forEach((el) => el.style.background = `url(${img}) 0 0 / 100% 100% no-repeat`)
    })
  } catch (error) {
    throw error;
  }
}

function playPause(elements, state) {
  elements.forEach((element) => (element.style.animationPlayState = state));
}

async function loadImage(src) {
  const image = new Image();

  return new Promise((resolve, reject) => {
    image.onload = () => resolve(src);
    image.onerror = () => reject(new Error(`Failed to load image: ${src}`));
    image.src = src;
  });
}

async function adjustFontSize(element) {
  try {
    const text = element.firstElementChild;
    const textComputedStyle = window.getComputedStyle(text, null);
    let textFontSize = parseFloat(
      textComputedStyle.getPropertyValue("font-size")
    );

    while (
      text.offsetWidth > element.clientWidth ||
      text.offsetHeight > element.clientHeight
    ) {
      if (textFontSize <= 0) break;
      textFontSize -= 0.5;
      text.style.fontSize = `${textFontSize}px`;

      // esperar renderizar as alteracoes
      await new Promise((resolve) => setTimeout(resolve, 20));
    }

    return textFontSize;
  } catch (error) {
    throw error;
  }
}

async function fillScenes(json) {
  try {
    await Promise.all([
      // setImagemAbertura(json),
      // setGiovana(json),
      setDestino(json),
      // setTitle(json),
      setSelos(json),
      setSeloPix(json),
      setOfertas(json),
      setTextoLegal(json),
      // setCores(json),
    ]);

    // showTemplate();
  } catch (error) {
    throw error;
  }
}

// ---------------------------------------------------------------------------------------------------------------
// * não mexer nesses eventos, são responsáveis por receber os dados do template e exibir na tela
// ---------------------------------------------------------------------------------------------------------------
window.addEventListener("message", (ev) => {
  const eventType = ev?.data?.type;

  switch (eventType?.toLowerCase()) {
    case "visibility":
      showTemplate(ev);
      break;
    case "template_data":
      prepareTemplate(ev);
      break;
  }
});

window.addEventListener("load", (event) => {
  window.parent.postMessage("load", "*");
});
// ---------------------------------------------------------------------------------------------------------------
// ---------------------------------------------------------------------------------------------------------------
