const autoSize = function (element, MIN_FONT_SIZE, MAX_FONT_SIZE, DELAY) {
    if (!DELAY || DELAY < 300) DELAY = 300;
    if (!MIN_FONT_SIZE || !MAX_FONT_SIZE || MIN_FONT_SIZE >= MAX_FONT_SIZE) {
      MIN_FONT_SIZE = 1;
      MAX_FONT_SIZE = 200;
    }
  
    let fontSize = MAX_FONT_SIZE;
    element.style.fontSize = fontSize + "px";
  
    setTimeout(resize, DELAY);
  
    function resize() {
      while (
        fontSize > MIN_FONT_SIZE &&
        element.scrollHeight > element.clientHeight
      ) {
        fontSize-=1;
        element.style.fontSize = fontSize + "px";
      }
    }
  };

function isImage(url) {
    const imageExtensions = /\.(jpg|jpeg|png|gif|bmp|svg)$/i;
    return imageExtensions.test(url);
  }

  function isVideo(url) {
    const videoExtensions = /\.(mp4|avi|wmv|mov|flv|mkv|webm)$/i;
    return videoExtensions.test(url);
  }

  function replaceHtml(item, mapElementId){
    for (let key in item){
      const value = item[key];
      const elementId = mapElementId[key];
      if((typeof elementId) === 'object'){
        for(let id in elementId){
          const element = document.getElementById(elementId[id]);
          if(value){
            if(element){
              if(isImage(value)){
                const img = new Image();
                img.src = value;
                element.prepend(img);
              } else if(isVideo(value)){
                const video = document.createElement('video');
                video.src = value;
                video.controls = true;
                video.autoplay = true;
                element.prepend(video);
              } else {
                element.innerText = value;
                if(elementId['autosize']){ 
                  //console.log(id);
                  autoSize(element, 1, elementId['autosize']);
                }
              }
            }
          } else {
            if(element){
              element.style.visibility = 'hidden';
            }
          }
        }
      }
    }
  }
  